**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*01 by size Figure 3 and Figure 4
*02 Figure 5
*03 testing differences
*04 Extra interact size
*05 Extra interact age
*06 Robusness

cd "${intermediates}"
use bas_final3.dta, clear



tsset firmid2 period

local hmax = 16

eststo clear 

cap drop b u d Years Zero
gen Years= _n-1 if _n<=`hmax'+1
g Zero=0 if _n<=`hmax'+1
gen b=0
gen u=0
gen d=0



*******01 by size figures 3 and 4


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if fsize=="Small", cluster (period firmid2) a(ind qr)
}

estout * using "${results}\intmargin_bas_small.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 
*/


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if fsize=="Medium", cluster (period firmid2) a(ind qr)
}

estout * using "${results}\intmargin_bas_medium.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  if fsize=="Large", cluster (period firmid2) a(ind qr)
}

estout * using "${results}\intmargin_bas_large.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if fsize=="Small", cluster (period firmid2) a(ind qr)
}

estout * using "${results}\extmargin_bas_small.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if fsize=="Medium", cluster (period firmid2) a(ind qr)
}

estout * using "${results}\extmargin_bas_medium.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if fsize=="Large", cluster (period firmid2) a(ind qr)
}

estout * using "${results}\extmargin_bas_large.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



***********************************02 Figure 5
**** by age 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if younger==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_younger.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if younger==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_older.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if younger==1 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_younger.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if younger==0 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_older.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



*/

*********03 Testing diffrences


**** by size figures b5 and b6

gen size= "."
replace size="3" if fsize=="Small"
replace size="2" if fsize=="Medium"
replace size="1" if fsize=="Large"

destring size, replace

gen small=(size==3)
gen medium=(size==2)
gen large=(size==1)

gen shock_small=beckers_aug*small
gen shock_medium=beckers_aug*medium
gen shock_large=beckers_aug*large

/*
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(0/1).shock_small l(0/1).shock_medium l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales , cluster (period firmid2) a(fsize_ ind qr)


}
estout * using "${results}\intmargin_bas_shocksize2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(0/1).shock_small l(0/1).shock_medium l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales  , cluster (period firmid2) a(fsize_ ind qr)
	
		
	
}


estout * using "${results}\extmargin_bas_shocksize2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


***04 Extra interact size
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.size##(l(0/1).c.beckers_aug  l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales)   , cluster (period firmid2) a(i.size##i.ind i.size##i.qr )


}
estout * using "${results}\intmargin_bas_shocksize_test_full.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 
*/

eststo clear 
forv h=0/16 {
	
	eststo: reghdfe extmargin_`h'  i.size##(l(0/1).c.beckers_aug  l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales)   , cluster (period firmid2) a(i.size##i.ind i.size##i.qr )
 
	
		
	
}

estout * using "${results}\extmargin_bas_shocksize_test_full.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


/*
***05 Extra interact age
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.younger##(l(0/1).c.beckers_aug  l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales)   , cluster (period firmid2) a(i.younger##i.ind i.younger##i.qr )


}
estout * using "${results}\intmargin_bas_shocksize_test_y_full.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

*/
eststo clear 
forv h=0/16 {
	
	eststo: reghdfe extmargin_`h'  i.younger##(l(0/1).c.beckers_aug  l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales)   , cluster (period firmid2) a(i.younger##i.ind i.younger##i.qr )
 
	
		
	
}

estout * using "${results}\extmargin_bas_shocksize_test_y_full.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


****************************************06 Robusness

**** by age post 2005

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if younger==1 & tsid>2005, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_younger2005.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if younger==0 & tsid>2005, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_older2005.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if younger==1 & tsid>2005, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_younger2005.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if younger==0 & tsid>2005, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_older2005.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



******* by size and age


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Small" & younger==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_smallyoung.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Small" & younger==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_smallold.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Medium" & younger==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_mediumyoung.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Medium" & younger==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_mediumold.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Large" & younger==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_largeyoung.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Large" & younger==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_largeold.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 





eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Small" & younger==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_smallyoung.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Small" & younger==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_smallold.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear  
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Medium" & younger==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_mediumyoung.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear  
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Medium" & younger==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_mediumold.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear  
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Large" & younger==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_largeyoung.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear  
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales i.ind i.qr if fsize=="Large" & younger==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_largeold.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 